//==============================================================================
// T P 2                                                                 Classe
// V i d e o t h e q u e  
//==============================================================================

// Cette classe complete la classe "Videotheque" creee dans le TP 1.

// Package //-------------------------------------------------------------------
package tp2;

// Importation //---------------------------------------------------------------
import entreeSortie.*;
import structures.*;
import tp1.*;

public class Videotheque extends tp1.Videotheque {
 //--------------------------------------------------------------------Attributs
 protected TriTableau triTableau;
 //-----------------------------------------------------------------Constructeur
 // Entrees: Taille maximale "n" de la videotheque.
 // Finalite: Construire une videotheque d'une taille maximale donnee.
 //
 public Videotheque(int n) {
  super(n);
  triTableau = new TriTableau(new ComparerFilms());
 }
 //-------------------------------------------------------------------Rechercher
 // Entrees: un titre "t".
 // Finalite: rechercher dans la videotheque le film ayant le titre "t".
 //           Si aucun film ne correspond au titre, le film le plus proche
 //           est pointe.
 // Sortie: le film trouve.
 // Hypotheses: la videotheque "v" est triee.
 // Variables inter: un entier "i" qui est l'indice du film trouve.
 // Strategie: parcours le tableau tant que le titre du film pointe
 //            est superieur au titre recherche.
 //
 public Film rechercher(String t) {
  int i = 0;
 
  if (taille == 0) {
   Ecran.ecrire("Le tableau est vide.\n");  
   return null;
  }
  
  while (i < taille && t.compareTo(tableau[i].titre) > 0) i++;

  if (i < taille) return tableau[i];
  else return tableau[taille - 1];
 }
 //-----------------------------------------------------------------Selectionner
 // Finalite: rechercher dans la videotheque le film ayant le
 //           titre saisi par l'utilisateur. Si le film n'est pas trouve
 //           alors l'utilisateur peut selectionner manuellement son film, en
 //           partant du titre qui est le plus proche de celui qu'il a donne.
 // Sortie: le film selectionne.
 // Hypotheses: le tableau "t" est trie.
 // Variables inter: un entier "i" qui est l'indice du film trouve,
 //                  une chaine de caractere "c" pour le titre saisi.
 // Strategie: demande a l'utilisateur un titre de film,
 //            recherche le film et ensuite permet a l'utilisateur
 //            de selectionner un film a partir de celui trouve.
 //
 public Film selectionner() {
  int i = 0;
  String c;
 
  if (taille == 0) {
   Ecran.ecrire("Le tableau est vide.\n");  
   return null;
  }
  
  Ecran.ecrire("Titre ? ");
  c = Clavier.lireChaine();

  while (i < taille && c.compareTo(tableau[i].titre) > 0) i++;
  if (i == taille) i = taille - 1;
  
  return confirmerSelection(i);
 }
 //-----------------------------------------------------------ConfirmerSelection
 // Entrees: l'indice "i" du film selectionne.
 // Finalite: permettre a l'utilisateur de se deplacer manuellement dans la
 //           videotheque a partir de l'indice "i" et de confirmer la
 //           selection d'un film.
 // Sortie: le film selectionne par l'utilisateur.
 // Variables inter: un booleen "ok" qui indique si l'utilisateur a
 //                  confirme la selection d'un film,
 //                  une chaine de caracteres "r" pour interroger l'utilisateur.
 // Strategie: tant que l'utilisateur n'a pas confirme la selection,
 //            lui demander dans quelle direction se deplacer dans le tableau.
 //
 protected Film confirmerSelection(int i) {
  boolean ok = false;
  String r;

  while (!ok) {
   Ecran.ecrire("Element " + i + " selectionne:\n");
   tableau[i].afficher();
   Ecran.ecrire("C'est le bon (o/n) ? ");
   r = Clavier.lireChaine();
   ok = r.equals("o"); 

   if (!ok) i = avancerReculer(i);
  }
 
  return tableau[i];
 }
 //---------------------------------------------------------------AvancerReculer
 // Entrees: l'indice "i" du film selectionne.
 // Finalite: demander a l'utilisateur s'il veut avancer ou reculer dans la
 //           videotheque a partir de l'indice courant "i".
 // Sortie: l'indice du film selectionne par l'utilisateur.
 // Hypotheses: le tableau "t" est trie.
 // Variables inter: une chaine de caracteres "r" pour interroger l'utilisateur.
 // Strategie: poser la question a l'utilisateur et modifier "i" en fonction
 //           de sa reponse.
 //
 protected int avancerReculer(int i) {
  String r;

  Ecran.ecrire("Precedent ou suivant (p/s) ? ");
  r = Clavier.lireChaine();
 
  if (r.equals("p") && i > 0) return (i - 1);
  if (r.equals("s") && i < taille - 1) return (i + 1);
 
  return i;
 }
 //---------------------------------------------------------------------Modifier
 // Finalite: permettre a l'utilisateur de selectionner un film dans la
 //           videotheque et de modifier ses donnees.
 // Hypotheses: la videotheque est triee.
 // Variables inter: "f" le film selectionne.
 // Strategie: selectionne un film grace a la methode "selectionner" et lance
 //            ensuite la methode "saisir" du film selectionne.
 public void modifier() {
  Film f = selectionner();
 
  if (f != null) {
   Ecran.ecrire("Les nouvelles donnees:\n");
   f.saisir();
  }
 }
 //---------------------------------------------------------------TrierSelection
 public void trierSelection() {
  triTableau.trierSelection(tableau,taille);
 }
 //------------------------------------------------------------------TrierFusion
 public void trierFusion() {
  triTableau.trierFusion(tableau,taille);
 }
}

// Classe  C o m p a r e r F i l m s //-----------------------------------------
class ComparerFilms implements Comparer {
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire un objet.
 //
 public void ComparerFilms() {}
 //-------------------------------------------------------------------------Egal
 // Finalite: retourner "VRAI" si les deux titres sont egaux.
 //
 public boolean egal(Object a,Object b) {
  Film fa = (Film)a;
  Film fb = (Film)b;
  
  return (fa.titre.equals(fb.titre) && fa.realisateur.equals(fb.realisateur));
 }
 //--------------------------------------------------------------------Inferieur
 // Finalite: retourner "VRAI" si le premier titre est inferieur au second.
 //
 public boolean inferieur(Object a,Object b) {
  Film fa = (Film)a;
  Film fb = (Film)b;
    
  return (fa.titre.compareTo(fb.titre) < 0 || (fa.titre.equals(fb.titre) &&
          fa.realisateur.compareTo(fb.realisateur) < 0));
 }
}

// Fin //-----------------------------------------------------------------------
