/*----------------------------------------------------------------------------*/
/* TP4: PILES                                                           TP4.H */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* gardien */

#ifndef TP4_H
#define TP4_H

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "../tp1/commun.h"

/*----------------------------------------------------------------------------*/
/* CONSTANTES */

#define NB_ANNEAUX 6
/* Nombre d'anneaux dans le jeu. */

/*----------------------------------------------------------------------------*/
/* TYPES */

typedef struct {
 int tab[NB_ANNEAUX];
 int n;
} PILE;

/*----------------------------------------------------------------------------*/
/* PROTOTYPES */

/* 1 */ /* Empile un entier au sommet d'une pile. */
void empiler(PILE * p,int e);

/* 2 */ /* Depile un entier du sommet d'une pile. */
int depiler(PILE * p);

/* 3 */ /* Affiche le contenu d'une pile. */
void afficherPile(PILE p);

/* 4 */ /* Prepare le jeu. */
void preparerJeu(PILE * t,int n,int dep);

/* 5 */ /* Affiche l'etat du jeu. */
void afficherJeu(PILE * t);

/* 6 */ /* Deplace des anneaux d'une pile a une autre. */
void deplacerAnneaux(PILE * t,int n,int a,int b);

/*----------------------------------------------------------------------------*/
/* FIN */

#endif
